/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.commands.PLA;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PLATest {
    private Cpu6502 cpu;
    private MemoryBlock memory;

    @Before
    public void setUp() {
        this.cpu = new Cpu6502();
        this.memory = new MemoryBlock(65536);
        ClockImplementation clock = new ClockImplementation();
        this.cpu.attach(this.memory, clock);
    }

    @Test
    public void testPopZero() throws EmulatorException {
        this.checkPopAndFlags(0, true, false);
    }

    @Test
    public void testPopPositive() throws EmulatorException {
        this.checkPopAndFlags(122, false, false);
    }

    @Test
    public void testPopNegative() throws EmulatorException {
        this.checkPopAndFlags(170, false, true);
    }

    private void checkPopAndFlags(int test_number, boolean zero_expected, boolean negative_expected) throws EmulatorException {
        this.cpu.setSP(new HwByte(254L));
        this.memory.write(511, test_number);
        this.cpu.setAccu(new HwByte(85L));
        new PLA().execute(this.cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte(255L), (Object)this.cpu.getSP());
        Assert.assertEquals((Object)new HwByte((long)test_number), (Object)this.cpu.getAccu());
        Assert.assertEquals((Object)zero_expected, (Object)this.cpu.getFlags().getZero());
        Assert.assertEquals((Object)negative_expected, (Object)this.cpu.getFlags().getNegative());
    }
}

